/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import parser.MyFileChooser;
import parser.ParserClient;

public class ParseFrame {
    static File currentpath = null;
    static Frame oldframe = null;
    static File actionsfile = null;
    static JLabel loglabel = null;
    private static DefaultListModel<File> loglist = new DefaultListModel();
    private static DefaultListModel<String> listModel = new DefaultListModel();
    private static JList<String> list = new JList<String>(listModel);
    private static int position = 0;

    public static void addComponentsToFrame(Container pane, ActionListener al, ListSelectionListener lsl) {
        FlowLayout fl = new FlowLayout();
        fl.setAlignment(4);
        pane.setLayout(fl);
        JPanel toppanel = new JPanel(new FlowLayout(0));
        toppanel.setMinimumSize(new Dimension(380, 40));
        toppanel.setMaximumSize(new Dimension(380, 40));
        toppanel.setPreferredSize(new Dimension(380, 40));
        list.setSelectionMode(0);
        list.addListSelectionListener(lsl);
        JScrollPane middlepanel = new JScrollPane(list);
        middlepanel.setMinimumSize(new Dimension(380, 420));
        middlepanel.setMaximumSize(new Dimension(380, 420));
        middlepanel.setPreferredSize(new Dimension(380, 420));
        JPanel middlepanel2 = new JPanel(new FlowLayout(0));
        middlepanel2.setMinimumSize(new Dimension(380, 40));
        middlepanel2.setMaximumSize(new Dimension(380, 40));
        middlepanel2.setPreferredSize(new Dimension(380, 40));
        JPanel lowerpanel = new JPanel();
        lowerpanel.setMinimumSize(new Dimension(380, 40));
        lowerpanel.setMaximumSize(new Dimension(380, 40));
        lowerpanel.setPreferredSize(new Dimension(380, 40));
        ParseFrame.addAButton("Open", toppanel, al);
        loglabel = new JLabel("Actions File");
        loglabel.setAlignmentX(0.5f);
        toppanel.add(loglabel);
        ParseFrame.addAButton("Add Log", middlepanel2, al);
        ParseFrame.addAButton("Remove Log", middlepanel2, al);
        ParseFrame.addAButton("Remove All", middlepanel2, al);
        ParseFrame.addAButton("Parse", lowerpanel, al);
        ParseFrame.addAButton("Cancel", lowerpanel, al);
        pane.add(toppanel);
        pane.add(middlepanel);
        pane.add(middlepanel2);
        pane.add(lowerpanel);
    }

    private static void addAButton(String text, Container container, ActionListener al) {
        JButton button = new JButton(text);
        button.setAlignmentX(0.5f);
        button.addActionListener(al);
        container.add(button);
    }

    private static void createAndShowGUI() {
        final JFrame frame = new JFrame("Simple Log Parser");
        frame.setDefaultCloseOperation(2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)((dimension.getWidth() - (double)frame.getWidth()) / 2.0);
        int y = (int)((dimension.getHeight() - (double)frame.getHeight()) / 2.0);
        frame.setLocation(x - 200, y - 300);
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(400, 600));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if ("Cancel".equals(actionEvent.getActionCommand())) {
                    listModel.removeAllElements();
                    loglist.removeAllElements();
                    frame.dispose();
                } else if ("Parse".equals(actionEvent.getActionCommand())) {
                    loglist.addElement(actionsfile);
                    ParserClient.dostuff(loglist, "-e");
                    JOptionPane.showMessageDialog(frame, "Logs have been analysed.", "Finished", -1);
                    loglist.removeElement(actionsfile);
                } else if ("Add Log".equals(actionEvent.getActionCommand())) {
                    MyFileChooser fc = new MyFileChooser(currentpath);
                    final File[] file = new File[]{fc.showDialogAndGetFile(frame)};
                    if (file[0] != null) {
                        currentpath = file[0];
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (!listModel.contains(file[0].getName())) {
                                    listModel.addElement(file[0].getName());
                                    loglist.addElement(file[0]);
                                }
                            }
                        });
                    }
                } else if ("Remove Log".equals(actionEvent.getActionCommand())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            listModel.removeElementAt(position);
                            loglist.removeElementAt(position);
                            position = -1;
                        }
                    });
                } else if ("Remove All".equals(actionEvent.getActionCommand())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            listModel.removeAllElements();
                            loglist.removeAllElements();
                        }
                    });
                } else if ("Open".equals(actionEvent.getActionCommand())) {
                    MyFileChooser fc = new MyFileChooser(currentpath);
                    File[] file = new File[]{fc.showDialogAndGetFile(frame)};
                    if (file[0] != null) {
                        currentpath = file[0];
                        actionsfile = file[0];
                        loglabel.setText(file[0].getName());
                    }
                }
            }
        };
        ListSelectionListener listselectionlistener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                if (list.getSelectedIndex() != -1) {
                    position = list.getSelectedIndex();
                }
            }
        };
        ParseFrame.addComponentsToFrame(frame.getContentPane(), actionListener, listselectionlistener);
        frame.add(panel);
        frame.setMinimumSize(new Dimension(400, 600));
        frame.setResizable(false);
        frame.setVisible(true);
    }

    public static void parselog(Frame f) {
        oldframe = f;
        ParseFrame.createAndShowGUI();
    }
}

