/*
 * Decompiled with CFR 0.152.
 */
package parser;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import parser.MyFileChooser;
import parser.ParseFrame;
import parser.ParserClient;

public class MainMenu {
    static JFrame frame;
    static File currentpath;

    static {
        currentpath = null;
    }

    public static void addComponentsToPane(Container pane, ActionListener al) {
        pane.setLayout(new GridLayout(6, 1));
        MainMenu.addALabel("Please choose one:", pane);
        MainMenu.addAButton("Repair Rules file", pane, al);
        MainMenu.addAButton("Numerate & Parse Rules file", pane, al);
        MainMenu.addAButton("Parse log file", pane, al);
        MainMenu.addAButton("Exit", pane, al);
    }

    private static void addAButton(String text, Container container, ActionListener al) {
        JButton button = new JButton(text);
        button.setAlignmentX(0.5f);
        button.addActionListener(al);
        container.add(button);
    }

    private static void addALabel(String text, Container container) {
        JLabel label = new JLabel(text);
        label.setAlignmentX(0.5f);
        container.add(label);
    }

    private static void createAndShowGUI() {
        frame = new JFrame("Simple Log Parser");
        frame.setDefaultCloseOperation(3);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (int)((dimension.getWidth() - (double)frame.getWidth()) / 2.0);
        int y = (int)((dimension.getHeight() - (double)frame.getHeight()) / 2.0);
        frame.setLocation(x - 100, y - 150);
        final JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(200, 300));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if ("Exit".equals(actionEvent.getActionCommand())) {
                    System.exit(0);
                } else if ("Repair Rules file".equals(actionEvent.getActionCommand())) {
                    MyFileChooser fc = new MyFileChooser(currentpath);
                    File[] file = new File[]{fc.showDialogAndGetFile(panel)};
                    if (file[0] != null) {
                        DefaultListModel<File> def = new DefaultListModel<File>();
                        def.addElement(file[0]);
                        ParserClient.dostuff(def, "-r");
                        currentpath = file[0];
                        JOptionPane.showMessageDialog(frame, "File has been repaired.", "Finished", -1);
                    }
                } else if ("Numerate & Parse Rules file".equals(actionEvent.getActionCommand())) {
                    MyFileChooser fc = new MyFileChooser(currentpath);
                    File[] file = new File[]{fc.showDialogAndGetFile(panel)};
                    if (file[0] != null) {
                        DefaultListModel<File> def = new DefaultListModel<File>();
                        def.addElement(file[0]);
                        ParserClient.dostuff(def, "-n");
                        currentpath = file[0];
                        JOptionPane.showMessageDialog(frame, "File has been numerated.", "Finished", -1);
                    }
                } else if ("Parse log file".equals(actionEvent.getActionCommand())) {
                    frame.setFocusable(false);
                    ParseFrame.parselog(frame);
                }
            }
        };
        MainMenu.addComponentsToPane(panel, actionListener);
        frame.add(panel);
        frame.setMinimumSize(new Dimension(200, 300));
        frame.setResizable(false);
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainMenu.createAndShowGUI();
            }
        });
    }
}

